import type { DayPickerBase, DayPickerSingleProps, } from "react-day-picker"
import { ButtonVariantProps } from "../button/button-variant";

export type DatePickerBaseProps = Omit<React.HTMLAttributes<HTMLDivElement>, "children" | "onSelect"> &
  Pick<DayPickerBase, "disabled"> & {
    size?: Exclude<ButtonVariantProps["size"], "icon">,
    variant?: Extract<ButtonVariantProps["variant"], "outline" | "ghost">,
  }

export type DatePickerItem = {
  display?: string | number,
  value: Date,
}

type OnDateSelectFunction = NonNullable<DayPickerSingleProps["onSelect"]>;
type OnDateSelectParameters = Parameters<OnDateSelectFunction>;
type OnDateSelectInternal = (
  date: OnDateSelectParameters["0"],
  selectedDay: OnDateSelectParameters["1"] | undefined,
  activeModifiers?: OnDateSelectParameters["2"],
  e?: OnDateSelectParameters["3"],
) => ReturnType<OnDateSelectFunction>

export type DatePickerProps = DatePickerBaseProps &
  Pick<DayPickerSingleProps, "selected" | "onSelect"> & {
    onSelect?: OnDateSelectInternal
  }
